//------------------------------------------------------------------
//
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  LimeGreen
#property indicator_color2  Orange
#property indicator_width1  2
#property indicator_width2  2

extern int bars          = 500;
extern int AveragePeriod = 20;

double histu[];
double histd[];
double ticks[];
double tick[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
int init()
{
   IndicatorBuffers(3);
   SetIndexBuffer(0,histu); SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,histd); SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,tick);  SetIndexEmptyValue(2,0);
      ArrayResize(ticks,bars); ArraySetAsSeries(ticks,true);
      IndicatorDigits(Digits);
   return(0);
}
int deinit() { return(0); }
int start()
{
   for (int i=bars-2; i>=0; i--) ticks[i+1] = ticks[i]; ticks[0] = Bid;
   ArrayCopy(tick,ticks,0,0,bars);      
   
   //
   //
   //
   //
   //
   
   for (i=bars-1; i>=0; i--)
   {
      histu[i] = EMPTY_VALUE;
      histd[i] = EMPTY_VALUE;
         double avg=tick[i];
            for (int k=1; k<AveragePeriod && tick[i+k]!=0; k++) avg += tick[i+k];
                                                                avg /= k;
         double diff = tick[i] - avg;
            if (diff>0) histu[i] = diff; 
            if (diff<0) histd[i] = diff; 
   }
   SetIndexDrawBegin(0,Bars-bars+1);
   SetIndexDrawBegin(1,Bars-bars+1);
   return(0);
}